(function(){
  function $(selector, ctx){ return (ctx||document).querySelector(selector); }
  function text(key, fallback){
    return (window.LoginWAOTP && window.LoginWAOTP.i18n && window.LoginWAOTP.i18n[key]) || fallback;
  }
  function setStatus(el, msg, ok){
    if(!el) return;
    el.textContent = msg || '';
    el.classList.toggle('loginwa-otp__status--success', !!ok);
    el.classList.toggle('loginwa-otp__status--error', ok === false);
  }

  function initForm(form){
    if(!form) return;
    const status = form.querySelector('.loginwa-otp__status');
    const sendBtn = form.querySelector('.loginwa-otp__send');
    const verifyBtn = form.querySelector('.loginwa-otp__verify');
    const isCompact = form.classList.contains('loginwa-otp__form--compact');
    const hint = form.querySelector('.loginwa-otp__hint');
    let sessionId = '';
    let cooldownTimer = null;

    sendBtn?.addEventListener('click', () => {
      const phone = form.phone.value.trim();
      const cc = form.country_code ? form.country_code.value.trim() : '';
      if(!phone){ setStatus(status, text('phoneRequired','Phone is required'), false); return; }
      if(sendBtn.disabled) return;
      sendBtn.disabled = true;
      if(hint){ hint.textContent = form.dataset.hintSending || text('sending','Sending...'); }
      fetch((form.dataset.rest || '').replace(/\/$/,'')+'/send', {
        method:'POST',
        headers:{'Content-Type':'application/json','X-WP-Nonce': form.dataset.nonce || (window.LoginWAOTP && LoginWAOTP.nonce) || ''},
        body: JSON.stringify({phone, country_code: cc})
      }).then(async r=>{
        const data = await r.json().catch(()=>({}));
        if(data.success){
          sessionId = data.session_id || '';
          setStatus(status, data.message || text('sent','OTP sent'), true);
          if(isCompact){ form.classList.add('is-otp-visible'); }
          startCooldown(sendBtn);
          if(hint){ hint.textContent = form.dataset.hintSuccess || text('sent','Code sent.'); }
        } else {
          setStatus(status, data.message || text('sendFailed','Failed to send OTP'), false);
          sendBtn.disabled = false;
          if(hint){ hint.textContent = form.dataset.hintDefault || ''; }
        }
      }).catch(()=> { setStatus(status, text('sendFailed','Failed to send OTP'), false); sendBtn.disabled = false; if(hint){ hint.textContent = form.dataset.hintDefault || ''; } });
    });

    verifyBtn?.addEventListener('click', () => {
      const otp = form.otp_code.value.trim();
      if(!otp){ setStatus(status, text('otpRequired','OTP is required'), false); return; }
      verifyBtn.disabled = true;
      fetch((form.dataset.rest || '').replace(/\/$/,'')+'/verify', {
        method:'POST',
        headers:{'Content-Type':'application/json','X-WP-Nonce': form.dataset.nonce || (window.LoginWAOTP && LoginWAOTP.nonce) || ''},
        body: JSON.stringify({otp_code: otp, session_id: sessionId})
      }).then(async r=>{
        const data = await r.json().catch(()=>({}));
        if(data.success){
          setStatus(status, data.message || text('verified','OTP verified.'), true);
          const redirect = form.dataset.redirect || '';
          if(redirect){ setTimeout(()=> { window.location.href = redirect; }, 300); }
        }
        else setStatus(status, data.message || text('verifyFailed','Verification failed'), false);
        verifyBtn.disabled = false;
      }).catch(()=> { setStatus(status, text('verifyFailed','Verification failed'), false); verifyBtn.disabled = false; });
    });

    function startCooldown(btn){
        const cooldown = (window.LoginWAOTP && LoginWAOTP.resendCooldown) ? parseInt(LoginWAOTP.resendCooldown,10) : 30;
        let remaining = isNaN(cooldown) ? 30 : cooldown;
        btn.disabled = true;
        clearInterval(cooldownTimer);
        if(!btn.dataset.originalLabel){ btn.dataset.originalLabel = btn.textContent; }
        cooldownTimer = setInterval(()=>{
            remaining -= 1;
            if(remaining <= 0){
                clearInterval(cooldownTimer);
                btn.disabled = false;
                btn.textContent = btn.dataset.originalLabel || 'Send code';
            } else {
                btn.textContent = (btn.dataset.originalLabel || 'Send code') + ' ('+remaining+'s)';
            }
        },1000);
    }
  }

  document.addEventListener('DOMContentLoaded', () => {
    const countries = (window.LoginWAOTPCountries || []).slice();

    function populateCountryRow(row){
      if(!row) return;
      const select = row.querySelector('.loginwa-otp__country');
      if(!select) return;
      const showFlags = row.dataset.showFlags === '1';
      const preferredRaw = (row.dataset.preferred || '').split(',').map(s=>s.trim()).filter(Boolean);
      const defaultCode = (row.dataset.defaultCountry || '').trim();
      const preferred = countries.filter(c => preferredRaw.includes(c.code));
      const rest = countries.filter(c => !preferredRaw.includes(c.code));
      const list = [...preferred, ...rest];
      select.innerHTML = '';
      list.forEach(c => {
        const opt = document.createElement('option');
        opt.value = c.code;
        opt.textContent = `${showFlags ? c.flag+' ' : ''}+${c.code} — ${c.name}`;
        if(defaultCode && c.code === defaultCode){ opt.selected = true; }
        select.appendChild(opt);
      });
    }

    document.querySelectorAll('.loginwa-otp__row--country').forEach(populateCountryRow);
    document.querySelectorAll('.loginwa-otp__form').forEach(initForm);
  });
})();
